/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.hud.impl;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.framework.objects.MouseButton;
import Krasnodar.rockstarnew.systems.modules.modules.visuals.Interface;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.ModeSetting;
import Krasnodar.rockstarnew.systems.theme.Theme;
import Krasnodar.rockstarnew.ui.hud.HudElement;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.game.EntityUtility;
import Krasnodar.rockstarnew.utility.game.TextUtility;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import Krasnodar.rockstarnew.utility.render.RenderUtility;
import Krasnodar.rockstarnew.utility.render.ScissorUtility;
import Krasnodar.rockstarnew.utility.time.Timer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_408;
import net.minecraft.class_742;
import net.minecraft.class_9334;

public class TargetHud
extends HudElement {
    private final BooleanSetting rayTrace = new BooleanSetting(this, "hud.targethud.look");
    private final ModeSetting armor = new ModeSetting(this, "hud.targethud.armor");
    private final ModeSetting.Value armorNone = new ModeSetting.Value(this.armor, "hud.targethud.armor.none");
    private final ModeSetting.Value armorNumber = new ModeSetting.Value(this.armor, "hud.targethud.armor.number").select();
    private final ModeSetting.Value armorIcon = new ModeSetting.Value(this.armor, "hud.targethud.armor.icon");
    private final Animation content = new Animation(300L, 0.0f, Easing.BAKEK_SIZE);
    private final Animation health = new Animation(300L, 0.0f, Easing.BAKEK);
    private final Animation golden = new Animation(300L, 0.0f, Easing.BAKEK);
    private final Animation number = new Animation(300L, 0.0f, Easing.FIGMA_EASE_IN_OUT);
    private final Animation itemsX = new Animation(300L, 0.0f, Easing.BAKEK);
    private final Animation copy = new Animation(300L, 0.0f, Easing.BAKEK);
    private final Animation success = new Animation(500L, 0.0f, Easing.BAKEK_SIZE);
    private final Animation eatingPulse = new Animation(150L, 0.0f, Easing.BAKEK);
    private final Animation pulseIntensity = new Animation(50L, 0.0f, Easing.SINE_IN_OUT);
    private final Animation[] items = new Animation[4];
    private class_1309 target;
    private final Timer copyTimer = new Timer();
    private boolean copied;

    public TargetHud() {
        super("hud.targethud", "icons/hud/target.png");
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new Animation(300L, 0.0f, Easing.BAKEK);
        }
    }

    @Override
    public void update(UIContext context) {
        super.update(context);
        this.width = 103.0f;
        this.height = 31.0f;
    }

    @Override
    protected void renderComponent(UIContext context) {
        class_1309 target = this.getTarget();
        if (target != null) {
            this.target = target;
        }
        if (this.target != null) {
            float f;
            float f2;
            Font regular7 = Fonts.REGULAR.getFont(7.0f);
            Font semibold6 = Fonts.SEMIBOLD.getFont(6.0f);
            boolean dark = Rockstar.getInstance().getThemeManager().getCurrentTheme() == Theme.DARK;
            ColorRGBA bgColor = Colors.getBackgroundColor().withAlpha(255.0f * (dark ? 0.8f - 0.6f * Interface.glass() : 0.7f));
            boolean hover = GuiUtility.isHovered(this.x + 30.0f, this.y + 3.0f + 6.0f * this.content.getValue(), 60.0, 6.0, context);
            if (!hover || this.copyTimer.finished(1000L)) {
                this.copied = false;
            }
            boolean isEating = this.target.method_6115() && this.target.method_6030().method_57826(class_9334.field_50075);
            this.eatingPulse.update(isEating);
            if (isEating) {
                float pulse = (float)Math.sin((double)System.currentTimeMillis() / 100.0) * 0.5f + 0.5f;
                this.pulseIntensity.setValue(pulse);
            }
            this.copy.update(hover);
            this.success.update(this.copied);
            this.content.update(this.animation.getValue() * this.visible.getValue() >= 1.0f);
            class_1309 class_13092 = this.target;
            if (class_13092 instanceof class_1657) {
                class_1657 player = (class_1657)class_13092;
                f2 = EntityUtility.getHealth(player);
            } else {
                f2 = this.target.method_6032();
            }
            this.health.update(f2 / this.target.method_6063());
            this.golden.update(this.target.method_6067() / 20.0f);
            class_1309 class_13093 = this.target;
            if (class_13093 instanceof class_1657) {
                class_1657 playerx = (class_1657)class_13093;
                f = EntityUtility.getHealth(playerx);
            } else {
                f = this.target.method_6032();
            }
            float healthNum = f;
            this.number.update(healthNum);
            if (this.animation.getValue() != 0.0f) {
                if (!this.armorNone.isSelected()) {
                    float prev = RenderSystem.getShaderColor()[3];
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    context.drawItem(class_1802.field_8058, -992.0f, 994.0f, 1.0f);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)prev);
                    float animOff = 0.0f;
                    int i = 0;
                    class_1799[] handItems = new class_1799[]{this.target.method_6047(), this.target.method_6079()};
                    for (class_1799[] itemStack : this.target.method_5661()) {
                        if (itemStack.method_7960()) continue;
                        animOff += (this.armorIcon.isSelected() ? 11.0f : 5.0f + semibold6.width(this.calculateDurabilityPercent((class_1799)itemStack))) + 2.0f;
                    }
                    float itemSize = 11.0f;
                    if (this.armorIcon.isSelected()) {
                        for (class_1799 handItem : handItems) {
                            if (handItem.method_7960()) continue;
                            animOff += 13.0f;
                        }
                    }
                    this.itemsX.update(animOff - 2.0f);
                    float xOffset = -this.itemsX.getValue() / 2.0f;
                    for (class_1799 itemStackx : this.target.method_5661()) {
                        this.items[i].update(!itemStackx.method_7960());
                        float anim = this.content.getValue() * this.items[i].getValue();
                        String percent = this.calculateDurabilityPercent(itemStackx);
                        boolean isIcon = this.armorIcon.isSelected();
                        float panelWidth = isIcon ? 11.0f : 5.0f + semibold6.width(percent);
                        float panelHeight = isIcon ? 11.0f : 9.0f;
                        float panelX = this.x + this.width / 2.0f + xOffset;
                        float panelY = this.y + this.height - 4.0f + 6.0f * anim;
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(prev * anim));
                        context.drawBlurredRect(panelX, panelY, panelWidth, panelHeight, 5.0f, BorderRadius.all(1.5f), ColorRGBA.WHITE.withAlpha(255.0f * this.animation.getValue()));
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)prev);
                        context.drawRoundedRect(panelX, panelY, panelWidth, panelHeight, BorderRadius.all(1.5f), bgColor.withAlpha(bgColor.getAlpha() * anim));
                        ScissorUtility.push(context.method_51448(), panelX, panelY, panelWidth, panelHeight);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(prev * anim * 0.5f));
                        if (this.armorNumber.isSelected()) {
                            context.drawItem(itemStackx, panelX - 11.0f + panelWidth / 2.0f + 2.0f, panelY - 4.0f, 1.0f);
                        } else {
                            context.drawItem(itemStackx, panelX - 11.0f + panelWidth / 2.0f + 5.5f, panelY, 0.7f);
                        }
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)prev);
                        ScissorUtility.pop();
                        if (this.armorNumber.isSelected()) {
                            context.drawText(semibold6, percent, panelX + 3.0f, panelY + 2.5f, Colors.getTextColor().withAlpha(255.0f * anim));
                        }
                        xOffset += (panelWidth + 2.0f) * anim;
                        ++i;
                    }
                    float handWidth = Arrays.stream(handItems).mapToInt(item -> item.method_7960() ? 0 : (int)(itemSize + 2.0f)).sum() - 2;
                    float handX = this.armorNumber.isSelected() ? -handWidth / 2.0f : xOffset;
                    for (class_1799 handItemx : handItems) {
                        if (handItemx.method_7960()) continue;
                        float handItemX = this.x + this.width / 2.0f + handX;
                        float handItemY = this.y + this.height - 4.0f + 6.0f * this.content.getValue() + (float)(this.armorNumber.isSelected() ? 12 : 0);
                        float alpha = this.content.getValue() * (isEating && this.target.method_6030() == handItemx ? 0.5f + 0.7f * this.pulseIntensity.getValue() : 1.0f);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(prev * alpha));
                        context.drawBlurredRect(handItemX, handItemY, itemSize, itemSize, 5.0f, BorderRadius.all(1.5f), ColorRGBA.WHITE.withAlpha(255.0f * this.animation.getValue()));
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)prev);
                        context.drawRoundedRect(handItemX, handItemY, itemSize, itemSize, BorderRadius.all(1.5f), bgColor.withAlpha(bgColor.getAlpha() * alpha));
                        ScissorUtility.push(context.method_51448(), handItemX, handItemY, itemSize, itemSize);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(prev * alpha));
                        context.drawItem(handItemx, handItemX - 11.0f + itemSize / 2.0f + 5.5f, handItemY, 0.7f);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)prev);
                        ScissorUtility.pop();
                        handX += itemSize + 2.0f;
                        if (!this.armorIcon.isSelected()) continue;
                        xOffset += (itemSize + 2.0f) * this.content.getValue();
                    }
                }
                context.drawShadow(this.x - 5.0f, this.y - 5.0f, this.width + 10.0f, this.height + 10.0f, 15.0f, BorderRadius.all(6.0f), ColorRGBA.BLACK.withAlpha(63.75f * this.dragAnim.getValue()));
                if (Interface.showMinimalizm()) {
                    context.drawBlurredRect(this.x, this.y, this.width, this.height, 45.0f, 7.0f, BorderRadius.all(6.0f), ColorRGBA.WHITE.withAlpha(255.0f * this.animation.getValue() * Interface.minimalizm()));
                }
                if (Interface.showGlass()) {
                    context.drawLiquidGlass(this.x, this.y, this.width, this.height, 7.0f, 0.08f - 0.07f * this.dragAnim.getValue(), BorderRadius.all(6.0f), ColorRGBA.WHITE.withAlpha(255.0f * this.animation.getValue() * Interface.glass()));
                }
                context.drawSquircle(this.x, this.y, this.width, this.height, 7.0f, BorderRadius.all(6.0f), bgColor);
                float alpha = 255.0f * this.content.getValue();
                ScissorUtility.push(context.method_51448(), this.x, this.y, this.width, this.height);
                class_1309 class_13094 = this.target;
                if (class_13094 instanceof class_742) {
                    class_742 playerxx = (class_742)class_13094;
                    context.drawHead(playerxx, this.x + 6.0f * this.content.getValue(), this.y + 6.0f, 19.0f, BorderRadius.all(3.0f), Colors.WHITE.withAlpha(alpha));
                } else {
                    context.drawRoundedTexture(Rockstar.id(Interface.glassSelected() ? "icons/hud/whoglass.png" : (Rockstar.getInstance().getThemeManager().getCurrentTheme() == Theme.DARK ? "icons/hud/whodark.png" : "icons/hud/who.png")), this.x + 6.0f * this.content.getValue(), this.y + 6.0f, 19.0f, 19.0f, BorderRadius.all(3.0f), Colors.WHITE.withAlpha(alpha));
                }
                String numberText = healthNum == 1000.0f ? "?" : TextUtility.formatNumber(this.number.getValue()).replace(",", ".");
                context.drawFadeoutText(regular7, this.target.method_5477().getString(), this.x + 30.0f + 8.0f * this.copy.getValue(), this.y + 3.0f + 6.0f * this.content.getValue(), Colors.getTextColor().withAlpha(alpha), 0.7f, 1.0f, this.width - 40.0f - 8.0f * this.copy.getValue() - semibold6.width(numberText));
                RenderUtility.rotate(context.method_51448(), this.x + 28.0f + 5.0f * this.copy.getValue(), this.y + 6.0f + 6.0f * this.content.getValue(), 90.0f * this.success.getValue());
                context.drawTexture(Rockstar.id("icons/hud/copy.png"), this.x + 25.0f + 5.0f * this.copy.getValue(), this.y + 3.0f + 6.0f * this.content.getValue(), 6.0f, 6.0f, Colors.getTextColor().withAlpha(alpha * this.copy.getValue() * (1.0f - this.success.getValue())));
                RenderUtility.end(context.method_51448());
                RenderUtility.rotate(context.method_51448(), this.x + 28.0f + 5.0f * this.copy.getValue(), this.y + 6.0f + 6.0f * this.content.getValue(), -90.0f + 90.0f * this.success.getValue());
                context.drawTexture(Rockstar.id("icons/check.png"), this.x + 25.0f + 5.0f * this.copy.getValue(), this.y + 3.0f + 6.0f * this.content.getValue(), 6.0f, 6.0f, Colors.GREEN.withAlpha(alpha * this.copy.getValue() * this.success.getValue()));
                RenderUtility.end(context.method_51448());
                context.drawRightText(semibold6, numberText, this.x + this.width - 7.0f, this.y + 4.0f + 6.0f * this.content.getValue(), Colors.ACCENT.withAlpha(alpha));
                context.drawRoundedRect(this.x + 30.0f, this.y + this.height - 6.0f - 6.0f * this.content.getValue(), 65.0f, 3.0f, BorderRadius.all(0.7f), Colors.getAdditionalColor().withAlpha(alpha * (1.0f - 0.7f * Interface.glass())));
                context.drawRoundedRect(this.x + 30.0f, this.y + this.height - 6.0f - 6.0f * this.content.getValue(), 65.0f * Math.clamp(this.health.getValue(), 0.0f, 1.0f), 3.0f, BorderRadius.all(0.7f), Colors.ACCENT.withAlpha(alpha));
                context.drawRoundedRect(this.x + 95.0f - 65.0f * Math.clamp(this.golden.getValue(), 0.0f, 1.0f), this.y + this.height - 6.0f - 6.0f * this.content.getValue(), 65.0f * Math.clamp(this.golden.getValue(), 0.0f, 1.0f), 3.0f, BorderRadius.all(0.7f), new ColorRGBA(255.0f, 220.0f, 81.0f, alpha));
                ScissorUtility.pop();
            }
        }
    }

    private String calculateDurabilityPercent(class_1799 itemStack) {
        if (!itemStack.method_7960() && itemStack.method_7963()) {
            int maxDurability = itemStack.method_7936();
            int currentDamage = itemStack.method_7919();
            if (currentDamage >= maxDurability) {
                return "0%";
            }
            double durabilityPercent = 100.0 - (double)currentDamage / (double)maxDurability * 100.0;
            return String.format("%.0f%%", durabilityPercent);
        }
        return "100%";
    }

    private class_1309 getTarget() {
        class_1309 target2;
        class_1309 mainTarget;
        class_1297 class_12972 = Rockstar.getInstance().getTargetManager().getCurrentTarget();
        class_1309 class_13092 = mainTarget = class_12972 instanceof class_1309 ? (target2 = (class_1309)class_12972) : null;
        if (mainTarget != null) {
            return mainTarget;
        }
        if (this.rayTrace.isEnabled() && (class_12972 = TargetHud.mc.field_1692) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return livingEntity;
        }
        return TargetHud.mc.field_1755 instanceof class_408 ? TargetHud.mc.field_1724 : null;
    }

    @Override
    public void onMouseClicked(double mouseX, double mouseY, MouseButton button) {
        if (GuiUtility.isHovered((double)(this.x + 30.0f), (double)(this.y + 3.0f + 6.0f * this.content.getValue()), 60.0, 6.0, mouseX, mouseY)) {
            TextUtility.copyText(TargetHud.mc.field_1724.method_5477().getString());
            this.copyTimer.reset();
            this.copied = true;
        } else {
            super.onMouseClicked(mouseX, mouseY, button);
        }
    }

    @Override
    public boolean show() {
        return this.getTarget() != null;
    }
}

